//------------------------
// PARAMETERS

float gRGBScale
<
   string paramClass="intrinsic";
   string paramName="RGBScale";
   string paramType="float";
> = 1.0;

float gInvRGBScale
<
   string paramClass="intrinsic";
   string paramName="InvRGBScale";
   string paramType="float";
> = 1.0;

float gBloomSceneIntensity
<
   string paramClass="intrinsic";
   string paramName="BloomSceneIntensity";
   string paramType="float";
> = 1.0;

float gBloomThreshold
<
   string paramClass="intrinsic";
   string paramName="BloomThreshold";
   string paramType="float";
> = 1.0;

float4 gBloomTintColorLinear
<
   string paramClass="param";
   string paramName="BloomTintColor";
   string paramType="color";
   bool linearColor=true;
> = float4(1,1,1,1);

float4 gBloomFilterTapSamples[8] : register(c0);
float4 gBloomFilterTapScales[8] : register(c48);

sampler gSampler0 : register(s0);

// END PARAMETERS


//------------------------------
// FUNCTION_VS FullScreenQuadVS

void main()
{
	gl_Position = gl_Vertex;
	
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
    gl_TexCoord[1].st = gl_MultiTexCoord1.st;
    gl_TexCoord[2].st = gl_MultiTexCoord2.st;
    gl_TexCoord[3].st = gl_MultiTexCoord3.st;
}

//---------------------------
// FUNCTION_VS Downsample4VS

void main()
{
	gl_Position = gl_Vertex;
	
    gl_TexCoord[0].st = gl_MultiTexCoord3.st + vec2(-1.0, -1.0);
    gl_TexCoord[1].st = gl_MultiTexCoord3.st + vec2( 1.0, -1.0);
    gl_TexCoord[2].st = gl_MultiTexCoord3.st + vec2(-1.0,  1.0);
    gl_TexCoord[3].st = gl_MultiTexCoord3.st + vec2( 1.0,  1.0);
}


//---------------------------
// FUNCTION_PS Downsample4PS

uniform sampler2DRect gSampler0;

uniform float gRGBScale;
uniform float gInvRGBScale;
uniform float gBloomSceneIntensity;
uniform float gBloomThreshold;

void main()
{
	vec4 finalRadiance = texture2DRect(gSampler0, gl_TexCoord[0].st) * 0.25;
	finalRadiance     += texture2DRect(gSampler0, gl_TexCoord[1].st) * 0.25;
	finalRadiance     += texture2DRect(gSampler0, gl_TexCoord[2].st) * 0.25;
	finalRadiance     += texture2DRect(gSampler0, gl_TexCoord[3].st) * 0.25;

#ifdef SCALERGBOUTPUT
	finalRadiance.rgb *= gInvRGBScale;
#endif

	finalRadiance.rgb *= gBloomSceneIntensity;
	finalRadiance.rgb -= gBloomThreshold;
	finalRadiance.rgb = max( vec3(0.0, 0.0, 0.0), finalRadiance.rgb );
	
#ifdef SCALERGBOUTPUT
	finalRadiance.rgb *= gRGBScale;
#endif

	gl_FragColor = vec4( finalRadiance.rgb, 1.0 );
}


//---------------------------------
// FUNCTION_PS SupersampleFilterPS

uniform sampler2DRect gSampler0;

void main()
{      
	gl_FragColor = texture2DRect(gSampler0, gl_TexCoord[3].st);
}


//-------------------------------------
// FUNCTION_PS BloomFilterHorizontalPS

uniform sampler2DRect gSampler0;

uniform vec4 gBloomFilterTapSamples[16];
uniform vec4 gBloomFilterTapScales[16];

#ifdef FILTER_16_SAMPLES
const int BloomFilterSamples = 16;
#endif
#ifdef FILTER_12_SAMPLES
const int BloomFilterSamples = 12;
#endif
#ifdef FILTER_8_SAMPLES
const int BloomFilterSamples = 8;
#endif
#ifdef FILTER_4_SAMPLES
const int BloomFilterSamples = 4;
#endif
#ifdef FILTER_2_SAMPLES
const int BloomFilterSamples = 2;
#endif

void main()
{
#ifdef DEBUG_ALPHACHANNEL
	gl_FragColor = texture2DRect( gSampler0, gl_TexCoord[3].st );
	return;
#endif
	vec3 sum = vec3( 0.0, 0.0, 0.0 );
	for( int i=0; i<BloomFilterSamples; i++ )
	{
		float scale = gBloomFilterTapScales[i].x;
//		float scale = 5.0;
		vec2 uvOffset = gBloomFilterTapSamples[i].xy;
		sum += scale * texture2DRect( gSampler0, gl_TexCoord[3].st + uvOffset ).rgb;
	}
	
	gl_FragColor = vec4(sum, 1.0);
}



//-----------------------------------
// FUNCTION_PS BloomFilterVerticalPS

uniform sampler2DRect gSampler0;

uniform vec4 gBloomFilterTapSamples[16];
uniform vec4 gBloomFilterTapScales[16];
uniform vec4 gBloomTintColorLinear;

#ifdef FILTER_16_SAMPLES
const int BloomFilterSamples = 16;
#endif
#ifdef FILTER_12_SAMPLES
const int BloomFilterSamples = 12;
#endif
#ifdef FILTER_8_SAMPLES
const int BloomFilterSamples = 8;
#endif
#ifdef FILTER_4_SAMPLES
const int BloomFilterSamples = 4;
#endif
#ifdef FILTER_2_SAMPLES
const int BloomFilterSamples = 2;
#endif

void main()
{
#ifdef DEBUG_ALPHACHANNEL
	gl_FragColor = texture2DRect( gSampler0, gl_TexCoord[3].st );
	return;
#endif
	vec3 sum = vec3( 0.0, 0.0, 0.0 );
	for( int i=0; i<BloomFilterSamples; i++ )
	{
//		float scale = gBloomFilterTapScales[i].x;
		float scale = 2.0;
		vec2 uvOffset = gBloomFilterTapSamples[i].xy;
		sum += scale * texture2DRect( gSampler0, gl_TexCoord[3].st + uvOffset ).rgb;
	}
	
	gl_FragColor = vec4(gBloomTintColorLinear.rgb * sum, 1.0);
}
